# Bulgarian Small Business Survey Platform

A mobile-first, minimalistic questionnaire platform built with PHP and JavaScript for conducting surveys about small and local businesses in Bulgaria.

## Features

- **Bilingual Support**: English and Bulgarian language options
- **Mobile-First Design**: Responsive design optimized for mobile devices
- **Dynamic Question Types**: Supports single-choice, multi-choice, matrix, and open-text questions
- **Smart Path Logic**: Automatically routes users to appropriate surveys based on their self-identification
- **Data Storage**: Responses are stored in JSON format for easy analysis
- **Session Management**: Maintains user progress and preferences
- **Progress Tracking**: Visual progress bar and question navigation

## File Structure

```
/
├── index.php              # Landing page with language selection
├── survey.php             # Path selection and form handling
├── questionnaire.php      # Main survey interface
├── completion.php         # Survey completion page
├── buyer_questions.json   # Buyer survey questions
├── seller_questions.json  # Seller survey questions
├── assets/
│   └── css/
│       └── style.css      # Main stylesheet
├── responses/             # Generated response files (created automatically)
└── README.md             # This file
```

## Setup Instructions

### Prerequisites

- PHP 7.4 or higher
- Web server (Apache, Nginx, or PHP built-in server)
- Write permissions for the `responses/` directory

### Installation

1. **Clone or download** the project files to your web server directory

2. **Set up the web server**:
   - For Apache/Nginx: Place files in your web root directory
   - For PHP built-in server: Run `php -S localhost:8000` in the project directory

3. **Set permissions** (if needed):
   ```bash
   chmod 755 responses/
   ```

4. **Access the platform**:
   - Open your browser and navigate to `http://localhost:8000` (or your server URL)
   - The platform will start with the language selection page

## Usage Flow

### 1. Language Selection
- Users choose between English and Bulgarian
- Selection is maintained throughout the session

### 2. Path Selection
- Users identify themselves as:
  - **Buyer**: Usually buy from small/local sellers
  - **Seller**: Currently sell (or plan to sell) products
  - **Both**: Buy and sell

### 3. Survey Completion
- Users are directed to the appropriate questionnaire
- Progress is tracked with a visual progress bar
- Questions are presented one at a time for better UX

### 4. Completion
- After completing the buyer survey, users who indicated they also sell are offered the seller survey
- Users can return to the start or take additional surveys

## Question Types Supported

### Single Choice
```json
{
  "type": "single-choice",
  "question": "Your question here?",
  "options": ["Option 1", "Option 2", "Option 3"]
}
```

### Multi Choice
```json
{
  "type": "multi-choice",
  "question": "Select all that apply:",
  "options": ["Option 1", "Option 2", "Option 3"]
}
```

### Matrix
```json
{
  "type": "matrix",
  "question": "Rate the following (1-5):",
  "options": ["Item 1", "Item 2", "Item 3"],
  "scale": [1, 2, 3, 4, 5]
}
```

### Open Text
```json
{
  "type": "open-text",
  "question": "Please share your thoughts:"
}
```

## Data Storage

Responses are stored in JSON files in the `responses/` directory with the following structure:

```json
{
  "timestamp": "2024-01-15 14:30:25",
  "language": "en",
  "user_path": "both",
  "survey_type": "buyer",
  "responses": {
    "1": "Yes",
    "2": ["Social media", "Online marketplaces"],
    "3": "Often (monthly or more)",
    // ... more responses
  }
}
```

### File Naming Convention
- Files are named by date: `YYYY-MM-DD_responses.json`
- Multiple responses per day are stored in the same file
- Each response is an array element in the JSON file

## Customization

### Adding New Questions
1. Edit the appropriate JSON file (`buyer_questions.json` or `seller_questions.json`)
2. Add new question objects following the existing format
3. Ensure unique question IDs

### Modifying Styles
1. Edit `assets/css/style.css`
2. The design uses CSS custom properties for easy theming
3. Mobile-first approach with responsive breakpoints

### Adding New Languages
1. Add translations to the `$translations` arrays in PHP files
2. Update language selection logic if needed
3. Consider adding RTL support for languages that require it

## Technical Details

### Frontend
- **Vanilla JavaScript**: No external dependencies
- **CSS3**: Modern features with fallbacks
- **HTML5**: Semantic markup for accessibility

### Backend
- **PHP**: Server-side processing and data handling
- **JSON**: Data storage and configuration
- **Sessions**: User state management

### Security Considerations
- Input sanitization for all user inputs
- CSRF protection through session management
- File write permissions properly configured
- No sensitive data stored in plain text

## Browser Support

- **Modern Browsers**: Chrome, Firefox, Safari, Edge (latest versions)
- **Mobile**: iOS Safari, Chrome Mobile, Samsung Internet
- **Fallbacks**: Graceful degradation for older browsers

## Performance

- **Optimized Loading**: Minimal external dependencies
- **Efficient Storage**: JSON format for easy parsing
- **Responsive Images**: Optimized for mobile data usage
- **Caching**: Static assets can be cached by browsers

## Troubleshooting

### Common Issues

1. **Responses not saving**:
   - Check write permissions on `responses/` directory
   - Ensure PHP has write access

2. **Questions not loading**:
   - Verify JSON files are valid
   - Check file permissions

3. **Styling issues**:
   - Clear browser cache
   - Check CSS file path

4. **Session problems**:
   - Ensure PHP sessions are enabled
   - Check session storage permissions

### Debug Mode
To enable debug mode, add this to the top of PHP files:
```php
error_reporting(E_ALL);
ini_set('display_errors', 1);
```

## License

This project is open source and available under the MIT License.

## Support

For questions or issues, please check the troubleshooting section above or create an issue in the project repository.
