<?php
session_start();

$lang = $_GET['lang'] ?? 'en';
$survey_completed = $_SESSION['survey_completed'] ?? false;
$survey_type = $_SESSION['survey_type'] ?? '';
$user_path = $_SESSION['user_path'] ?? '';

// Language translations
$translations = [
    'en' => [
        'completion_title' => 'Thank you for your responses!',
        'completion_message' => 'Your feedback helps us understand the needs of small businesses and buyers in Bulgaria.',
        'seller_survey_link' => 'Take the Seller Survey',
        'seller_survey_message' => 'Since you mentioned you also sell products, would you like to share your experience as a seller?',
        'back_to_start' => 'Back to Start'
    ],
    'bg' => [
        'completion_title' => 'Благодарим за отговорите!',
        'completion_message' => 'Вашите отзиви ни помагат да разберем нуждите на малките бизнеси и купувачите в България.',
        'seller_survey_link' => 'Направете проучването за продавачи',
        'seller_survey_message' => 'Тъй като споменахте, че също продавате продукти, бихте ли искали да споделите опита си като продавач?',
        'back_to_start' => 'Обратно към началото'
    ]
];

$current_lang = $translations[$lang] ?? $translations['en'];

// Check if user should see seller survey link
$show_seller_link = false;
if ($survey_completed && $survey_type === 'buyer') {
    // Check if user selected "both" or if they indicated they are also a seller
    if ($user_path === 'both') {
        $show_seller_link = true;
    } else {
        // Check buyer responses for seller indication
        $responses_file = 'responses/' . date('Y-m-d') . '_responses.json';
        if (file_exists($responses_file)) {
            $responses = json_decode(file_get_contents($responses_file), true);
            $latest_response = end($responses);
            
            if ($latest_response && isset($latest_response['responses'])) {
                $buyer_responses = json_decode($latest_response['responses'], true);
                // Check question 16 (Do you currently sell, or plan to sell...)
                if (isset($buyer_responses['16'])) {
                    $seller_response = $buyer_responses['16'];
                    // Check both English and Bulgarian responses
                    $seller_indicators = [
                        'Yes, I already sell', 'Not yet, but I plan to in the future', // English
                        'Да, вече продавам', 'Все още не, но планирам в бъдеще' // Bulgarian
                    ];
                    if (in_array($seller_response, $seller_indicators)) {
                        $show_seller_link = true;
                    }
                }
            }
        }
    }
}

// Clear session data
if ($survey_completed) {
    unset($_SESSION['survey_completed']);
    unset($_SESSION['survey_type']);
    unset($_SESSION['user_path']);
    unset($_SESSION['language']);
}
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $lang === 'bg' ? 'Проучването е завършено' : 'Survey Completed'; ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="survey-container">
            <div class="completion-container">
                <div class="completion-icon">✅</div>
                <h1 class="completion-title"><?php echo $current_lang['completion_title']; ?></h1>
                <p class="completion-message"><?php echo $current_lang['completion_message']; ?></p>
                
                <?php if ($show_seller_link): ?>
                <div class="seller-survey-section">
                    <p><?php echo $current_lang['seller_survey_message']; ?></p>
                    <a href="questionnaire.php?type=seller&lang=<?php echo $lang; ?>" class="seller-link">
                        <?php echo $current_lang['seller_survey_link']; ?>
                    </a>
                </div>
                <?php endif; ?>
                
                <div class="nav-buttons" style="justify-content: center; margin-top: 40px;">
                    <a href="index.php" class="btn btn-secondary">
                        <?php echo $current_lang['back_to_start']; ?>
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
