<?php
session_start();

// Clear session if requested
if (isset($_GET['clear'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulgarian Small Business Survey</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <div class="language-selection">
            <div class="logo">
                <h1>🇧🇬</h1>
            </div>
            
            <div class="hero-section">
                <h2>Choose your language / Изберете език</h2>
                <p class="subtitle">Select your preferred language to continue</p>
            </div>
            
            <div class="language-buttons">
                <a href="survey.php?lang=en" class="lang-btn">
                    <span class="flag">🇺🇸</span>
                    <span class="lang-text">English</span>
                </a>
                <a href="survey.php?lang=bg" class="lang-btn">
                    <span class="flag">🇧🇬</span>
                    <span class="lang-text">Български</span>
                </a>
            </div>
            
            <div style="margin-top: 20px; text-align: center;">
                <a href="?clear=1" style="color: #999; text-decoration: none; font-size: 0.8rem;">
                    Clear session data
                </a>
            </div>
        </div>
    </div>
</body>
</html>
