<?php
session_start();

// Language translations
$translations = [
    'en' => [
        'hero_title' => 'Help us understand how people in Bulgaria connect with small and local businesses.',
        'hero_description' => 'We\'re conducting a short survey to learn more about how Bulgarians discover, buy, and sell products from small and independent businesses — from handmade gifts and crafts to natural lifestyle goods and eco products. Your answers will help us understand what works well, what challenges exist, and what could make the experience better for everyone.',
        'path_question' => 'When it comes to small and local businesses in Bulgaria, which describes you best?',
        'path_buyer' => 'I usually buy from small/local sellers',
        'path_seller' => 'I currently sell (or plan to sell) products',
        'path_both' => 'Both — I buy and sell',
        'next' => 'Next',
        'previous' => 'Previous',
        'submit' => 'Submit Survey',
        'completion_title' => 'Thank you for your responses!',
        'completion_message' => 'Your feedback helps us understand the needs of small businesses and buyers in Bulgaria.',
        'seller_survey_link' => 'Take the Seller Survey',
        'seller_survey_message' => 'Since you mentioned you also sell products, would you like to share your experience as a seller?'
    ],
    'bg' => [
        'hero_title' => 'Помогнете ни да разберем как хората в България се свързват с малки и местни бизнеси.',
        'hero_description' => 'Провеждаме кратко проучване, за да научим повече за това как българите откриват, купуват и продават продукти от малки и независими бизнеси — от ръчно изработени подаръци и занаяти до естествени лайфстайл продукти и еко продукти. Вашите отговори ще ни помогнат да разберем какво работи добре, какви предизвикателства съществуват и какво би могло да направи опитът по-добър за всички.',
        'path_question' => 'Когато става въпрос за малки и местни бизнеси в България, кое ви описва най-добре?',
        'path_buyer' => 'Обикновено купувам от малки/местни продавачи',
        'path_seller' => 'В момента продавам (или планирам да продавам) продукти',
        'path_both' => 'И двете — купувам и продавам',
        'next' => 'Напред',
        'previous' => 'Назад',
        'submit' => 'Изпрати проучването',
        'completion_title' => 'Благодарим за отговорите!',
        'completion_message' => 'Вашите отзиви ни помагат да разберем нуждите на малките бизнеси и купувачите в България.',
        'seller_survey_link' => 'Направете проучването за продавачи',
        'seller_survey_message' => 'Тъй като споменахте, че също продавате продукти, бихте ли искали да споделите опита си като продавач?'
    ]
];

$lang = $_GET['lang'] ?? 'en';
$current_lang = $translations[$lang] ?? $translations['en'];

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'save_path':
                $_SESSION['user_path'] = $_POST['path'];
                $_SESSION['language'] = $lang;
                header('Location: questionnaire.php?type=' . $_POST['path'] . '&lang=' . $lang);
                exit;
            case 'save_survey':
                $survey_data = [
                    'timestamp' => date('Y-m-d H:i:s'),
                    'language' => $lang,
                    'user_path' => $_SESSION['user_path'] ?? 'unknown',
                    'survey_type' => $_POST['survey_type'],
                    'responses' => $_POST['responses'] ?? []
                ];
                
                // Save to file
                $filename = 'responses/' . date('Y-m-d') . '_responses.json';
                if (!is_dir('responses')) {
                    mkdir('responses', 0755, true);
                }
                
                $existing_data = [];
                if (file_exists($filename)) {
                    $existing_data = json_decode(file_get_contents($filename), true) ?? [];
                }
                
                $existing_data[] = $survey_data;
                file_put_contents($filename, json_encode($existing_data, JSON_PRETTY_PRINT));
                
                $_SESSION['survey_completed'] = true;
                $_SESSION['survey_type'] = $_POST['survey_type'];
                header('Location: completion.php?lang=' . $lang);
                exit;
        }
    }
}

// Check if user has already selected a path
$user_path = $_SESSION['user_path'] ?? null;

// If no language is set in session AND no language in GET, redirect to index
if (!isset($_SESSION['language']) && !isset($_GET['lang'])) {
    header('Location: index.php');
    exit;
}

// Always update language from GET parameter if provided
if (isset($_GET['lang'])) {
    $_SESSION['language'] = $_GET['lang'];
    $lang = $_GET['lang'];
    $current_lang = $translations[$lang] ?? $translations['en'];
} else {
    // Use session language if no GET parameter
    $lang = $_SESSION['language'] ?? 'en';
    $current_lang = $translations[$lang] ?? $translations['en'];
}
?>

<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulgarian Small Business Survey</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="container">
        <?php if (!$user_path): ?>
        <!-- Path Selection Page -->
        <div class="survey-container">
            <div class="hero-section-large">
                <h1 class="hero-title"><?php echo $current_lang['hero_title']; ?></h1>
                <p class="hero-description"><?php echo $current_lang['hero_description']; ?></p>
            </div>
            
            <form method="POST" id="pathForm">
                <input type="hidden" name="action" value="save_path">
                <input type="hidden" name="lang" value="<?php echo $lang; ?>">
                
                <div class="question-container active">
                    <h2 class="question-text"><?php echo $current_lang['path_question']; ?></h2>
                    <div class="path-options">
                        <div class="path-option" data-value="buyer">
                            <input type="radio" name="path" value="buyer" id="path-buyer" style="display: none;">
                            <label for="path-buyer"><?php echo $current_lang['path_buyer']; ?></label>
                        </div>
                        <div class="path-option" data-value="seller">
                            <input type="radio" name="path" value="seller" id="path-seller" style="display: none;">
                            <label for="path-seller"><?php echo $current_lang['path_seller']; ?></label>
                        </div>
                        <div class="path-option" data-value="both">
                            <input type="radio" name="path" value="both" id="path-both" style="display: none;">
                            <label for="path-both"><?php echo $current_lang['path_both']; ?></label>
                        </div>
                    </div>
                </div>
                
                <div class="nav-buttons">
                    <a href="index.php" class="btn btn-secondary">
                        ← Back to Language Selection
                    </a>
                    <button type="submit" class="btn btn-primary" id="nextBtn" disabled>
                        <?php echo $current_lang['next']; ?>
                    </button>
                </div>
            </form>
        </div>
        <?php endif; ?>
    </div>

    <script>
        // Path selection functionality
        document.addEventListener('DOMContentLoaded', function() {
            const pathOptions = document.querySelectorAll('.path-option');
            const nextBtn = document.getElementById('nextBtn');
            
            pathOptions.forEach(option => {
                option.addEventListener('click', function() {
                    // Remove selected class from all options
                    pathOptions.forEach(opt => opt.classList.remove('selected'));
                    
                    // Add selected class to clicked option
                    this.classList.add('selected');
                    
                    // Check the radio button
                    const radio = this.querySelector('input[type="radio"]');
                    radio.checked = true;
                    
                    // Enable next button
                    nextBtn.disabled = false;
                });
            });
        });
    </script>
</body>
</html>
